# initialise parameter values
r = 0.2
N0 = 2
t_max = 10
Ns = numeric(t_max+1)
Ns[1] = N0

# run the loop, using the Poisson distribution to update the
# population size
for ( t in 1:t_max )
  Ns[t+1] = rpois(1,(1+r)*Ns[t])

# plot the results
plot(0:t_max,Ns,pch=19,type='o',xlab='t',ylab='N') 
